=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed August 2009 by Fredo6

# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   CurviloftLOader.rb
# Original Date	:   5 Sep 2009 - version 1.0
# Description	:   Loader for the Curviloft scripts
# Menu Items	:   Tools --> submenu "Curviloft"
# Toolbar		:   Name = "Curviloft"
# Usage			:   See Tutorial and Quick Ref Card in PDF format
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

module Curviloft

#---------------------------------------------------------------------------------------------------------------------------
# Overall Configuration for the Tools	
#---------------------------------------------------------------------------------------------------------------------------

MENU_PERSO = [:T_MenuTools_Fredo6Collection, "Tools", :T_MenuPlugins_Fredo6Collection, "Plugins"]

#---------------------------------------------------------------------------------------------------------------------------
#Constants for TOS  Modules (do not translate here, use Translation Dialog Box instead)	
#---------------------------------------------------------------------------------------------------------------------------

#Menu and Toolbar icons
T6[:CVL_LOFT_SPLINE_Menu] = "Loft by Spline"
T6[:CVL_LOFT_SPLINE_Tooltip] = "Create Loft junctions between surfaces based on Spline curves"
CVL_LOFT_SPLINE_Icon = "LoftSpline"

T6[:CVL_LOFT_PATH_Menu] = "Loft along path"
T6[:CVL_LOFT_PATH_Tooltip] = "Create Loft junctions following a given path"
CVL_LOFT_PATH_Icon = "LoftPath"

T6[:CVL_LOFT_SKIN_Menu] = "Skin Contours"
T6[:CVL_LOFT_SKIN_Tooltip] = "Skinning of shapes (Loft junctions following two pathes)"
CVL_LOFT_SKIN_Icon = "LoftSkin"

T6[:CVL_CURVE_MOVER_Menu] = "Curve Mover"
T6[:CVL_CURVE_MOVER_Tooltip] = "Move extremities of a curve"
CVL_CURVE_MOVER_Icon = "CurveMover"

#--------------------------------------------------------
# Default Parameters
#--------------------------------------------------------

T6[:CVL_DEFAULT_SECTION_General] = "Parameters at startup of Sketchup"
T6[:CVL_COLOR_Wireframe] = "Color for wireframe"

#--------------------------------------------------------
# Startup routine (called from LibFredo6)
#--------------------------------------------------------
	
#Create all commands with menus and toolbar icons
def Curviloft.startup	

	#Top menu
	MYPLUGIN.declare_topmenu nil, MENU_PERSO

	#Declaring command icons
	MYPLUGIN.declare_separator
	MYPLUGIN.declare_command(:CVL_LOFT_SPLINE_) { Curviloft.launch_loft({ :method => :splineloft}) }
	MYPLUGIN.declare_command(:CVL_LOFT_PATH_) { Curviloft.launch_loft({ :method => :along_path}) }
	MYPLUGIN.declare_command(:CVL_LOFT_SKIN_) { Curviloft.launch_loft({ :method => :skinning}) }
	#MYPLUGIN.declare_command(:CVL_CURVE_MOVER_) { Curviloft.launch_curve_mover }
	
	#Declaring the default parameter
	Curviloft.default_param
	
	#Startup of the Plugin
	MYPLUGIN.go	
	
end
	
#Declaring the Default Parameters	
def Curviloft.default_param
	dp = MYDEFPARAM
	dp.separator :CVL_DEFAULT_SECTION_General
	dp.declare :CVL_COLOR_Wireframe, "purple", "K"	
end
		
end	#End Module Curviloft
